/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.utils;

import com.google.common.collect.ImmutableMap;
import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.blocks.VerticalSlabBlockEntity;
import crystalspider.justverticalslabs.items.VerticalSlabBlockItem;
import crystalspider.justverticalslabs.recipes.crafting.VerticalSlabCraftingRecipe;
import crystalspider.justverticalslabs.recipes.stonecutter.VerticalSlabStonecutterRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class VerticalSlabUtils {
    public static final String NBT_ID = "referredSlabState";
    public static final ModelProperty<BlockState> REFERRED_SLAB_STATE = new ModelProperty();

    @Nonnull
    public static final ModelData buildModelData(BlockState referredSlabState) {
        return ModelData.builder().with(REFERRED_SLAB_STATE, (Object)referredSlabState).build();
    }

    public static final ResourceLocation getResourceLocation(String id) {
        return new ResourceLocation("justverticalslabs", id);
    }

    public static final boolean isTranslucent(BlockState referredSlabState) {
        return VerticalSlabUtils.isTranslucent(referredSlabState.m_60734_().m_5456_());
    }

    public static final boolean isTranslucent(Item slab) {
        return MapsManager.translucentMap.containsKey((Object)slab);
    }

    public static final ItemStack getDefaultInstance() {
        return VerticalSlabUtils.getVerticalSlabItem(Blocks.f_50398_.m_49966_(), false);
    }

    public static final ItemStack getVerticalSlabItem(BlockState referredSlabState, boolean translucent) {
        return translucent ? VerticalSlabUtils.getItemStackWithState((ItemLike)JustVerticalSlabsLoader.TRANSLUCENT_VERTICAL_SLAB_BLOCK.get(), referredSlabState) : VerticalSlabUtils.getItemStackWithState((ItemLike)JustVerticalSlabsLoader.CUTOUT_VERTICAL_SLAB_BLOCK.get(), referredSlabState);
    }

    public static final ItemStack getItemStackWithState(ItemLike itemLike, BlockState referredSlabState) {
        ItemStack itemStack = new ItemStack(itemLike);
        BlockItem.m_186338_((ItemStack)itemStack, (BlockEntityType)((BlockEntityType)JustVerticalSlabsLoader.VERTICAL_SLAB_BLOCK_ENTITY.get()), (CompoundTag)VerticalSlabUtils.putReferredSlabState(new CompoundTag(), referredSlabState));
        return itemStack;
    }

    public static final CompoundTag putReferredSlabState(CompoundTag compoundTag, BlockState referredSlabState) {
        compoundTag.m_128365_(NBT_ID, (Tag)NbtUtils.m_129202_((BlockState)referredSlabState));
        return compoundTag;
    }

    @Nullable
    public static final VerticalSlabBlockEntity getVerticalSlabBlockEntity(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof VerticalSlabBlockEntity) {
            return (VerticalSlabBlockEntity)blockEntity;
        }
        return null;
    }

    @Nullable
    public static final VerticalSlabBlockEntity getSafeVerticalSlabBlockEntity(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.getExistingBlockEntity(pos);
        if (blockEntity != null && blockEntity instanceof VerticalSlabBlockEntity) {
            return (VerticalSlabBlockEntity)blockEntity;
        }
        return null;
    }

    @Nullable
    public static final BlockState getReferredSlabState(BlockGetter getter, BlockPos pos) {
        VerticalSlabBlockEntity blockEntity = VerticalSlabUtils.getVerticalSlabBlockEntity(getter, pos);
        if (blockEntity != null) {
            BlockState referredSlabState = blockEntity.getReferredSlabState();
            return referredSlabState;
        }
        return null;
    }

    @Nullable
    public static final BlockState getSafeReferredSlabState(BlockGetter getter, BlockPos pos) {
        VerticalSlabBlockEntity blockEntity = VerticalSlabUtils.getSafeVerticalSlabBlockEntity(getter, pos);
        if (blockEntity != null) {
            BlockState referredSlabState = blockEntity.getReferredSlabState();
            return referredSlabState;
        }
        return null;
    }

    @Nullable
    public static final BlockState getReferredSlabState(ItemStack itemStack) {
        CompoundTag compoundTag;
        if (itemStack.m_41720_() instanceof VerticalSlabBlockItem && (compoundTag = itemStack.m_41737_("BlockEntityTag")) != null && (compoundTag = compoundTag.m_128469_(NBT_ID)) != null) {
            return NbtUtils.m_129241_((CompoundTag)compoundTag);
        }
        return null;
    }

    @Nullable
    public static final BlockState getReferredBlockState(BlockGetter getter, BlockPos pos) {
        return VerticalSlabUtils.getReferredBlockState(VerticalSlabUtils.getReferredSlabState(getter, pos));
    }

    @Nullable
    public static final BlockState getReferredBlockState(BlockState referredSlabState) {
        if (referredSlabState != null && MapsManager.slabMap.containsKey((Object)referredSlabState.m_60734_().m_5456_())) {
            return Block.m_49814_((Item)((Item)MapsManager.slabMap.get((Object)referredSlabState.m_60734_().m_5456_()))).m_49966_();
        }
        return null;
    }

    public static class MapsManager {
        @Nullable
        public static volatile ImmutableMap<Item, Item> waxingMap;
        @Nullable
        public static volatile ImmutableMap<Item, Item> stonecuttingMap;
        @Nullable
        public static volatile ImmutableMap<Item, Item> blockMap;
        @Nullable
        public static volatile ImmutableMap<Item, Item> slabMap;
        @Nullable
        public static volatile ImmutableMap<Item, BlockState> translucentMap;
        @Nullable
        public static volatile ImmutableMap<Item, BlockState> slabStateMap;
        @Nullable
        private static RecipeManager fallbackRecipeManager;

        public static final void setFallbackRecipeManager(RecipeManager recipeManager) {
            fallbackRecipeManager = recipeManager;
        }

        public static final void computeMaps() {
            if (fallbackRecipeManager != null) {
                MapsManager.computeMaps(fallbackRecipeManager);
            } else {
                JustVerticalSlabsLoader.LOGGER.warn("Tried to compute justverticalslabs mod maps without a RecipeManager: maps will be empty.");
                slabStateMap = ImmutableMap.of();
                translucentMap = ImmutableMap.of();
                slabMap = ImmutableMap.of();
                blockMap = ImmutableMap.of();
                stonecuttingMap = ImmutableMap.of();
                waxingMap = ImmutableMap.of();
            }
        }

        public static final void computeMaps(RecipeManager recipeManager) {
            JustVerticalSlabsLoader.LOGGER.debug("Computing justverticalslabs mod maps.");
            LinkedHashMap<Item, BlockState> slabStateMap = new LinkedHashMap<Item, BlockState>();
            LinkedHashMap<Item, BlockState> translucentMap = new LinkedHashMap<Item, BlockState>();
            HashMap slabMap = new HashMap();
            HashMap blockMap = new HashMap();
            HashMap<Item, Item> waxingMap = new HashMap<Item, Item>();
            HashMap<Item, Item> stonecuttingMap = new HashMap<Item, Item>();
            for (Item slab : ForgeRegistries.ITEMS.tags().getTag(ItemTags.f_13139_)) {
                JustVerticalSlabsLoader.LOGGER.debug("Adding " + slab + " to justverticalslabs mod maps...");
                slabStateMap.put(slab, Block.m_49814_((Item)slab).m_49966_());
                if (MapsManager.isTranslucent(slab.m_7968_().toString())) {
                    translucentMap.put(slab, Block.m_49814_((Item)slab).m_49966_());
                }
                for (CraftingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44107_)) {
                    ItemStack oxidizableSlab;
                    if (!recipe.m_8043_().m_150930_(slab) || recipe instanceof VerticalSlabCraftingRecipe) continue;
                    NonNullList ingredients = recipe.m_7527_();
                    List<Ingredient> blockIngredients = MapsManager.getBlockIngredients((NonNullList<Ingredient>)ingredients);
                    if (MapsManager.sameIngredients(blockIngredients)) {
                        blockIngredients.stream().findFirst().ifPresent(ingredient -> {
                            ItemStack[] items;
                            for (ItemStack itemStack : items = ingredient.m_43908_()) {
                                if (MapsManager.isPlain(itemStack.toString())) {
                                    slabMap.put(slab, itemStack.m_41720_());
                                }
                                blockMap.putIfAbsent(itemStack.m_41720_(), slab);
                            }
                            if (!slabMap.containsKey(slab) && items.length > 0) {
                                slabMap.put(slab, items[0].m_41720_());
                            }
                        });
                        continue;
                    }
                    if (!ingredients.stream().anyMatch(ingredient -> ingredient.test(Items.f_42784_.m_7968_()))) continue;
                    List<Ingredient> notHoneyIngredients = ingredients.stream().filter(ingredient -> !ingredient.test(Items.f_42784_.m_7968_())).toList();
                    ItemStack[] items = notHoneyIngredients.get(0).m_43908_();
                    if (notHoneyIngredients.size() != 1 || items.length <= 0 || !(oxidizableSlab = items[0]).m_204117_(ItemTags.f_13139_)) continue;
                    waxingMap.put(oxidizableSlab.m_41720_(), slab);
                }
                for (CraftingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44112_)) {
                    if (!recipe.m_8043_().m_150930_(slab) || recipe instanceof VerticalSlabStonecutterRecipe) continue;
                    Ingredient ingredient2 = (Ingredient)recipe.m_7527_().get(0);
                    for (ItemStack itemStack : ingredient2.m_43908_()) {
                        Item block = itemStack.m_41720_();
                        if (!stonecuttingMap.containsKey(block)) {
                            stonecuttingMap.put(block, slab);
                            continue;
                        }
                        if (slabMap.get(slab) != block) continue;
                        stonecuttingMap.put(block, slab);
                    }
                }
            }
            MapsManager.slabStateMap = ImmutableMap.copyOf(slabStateMap);
            MapsManager.translucentMap = ImmutableMap.copyOf(translucentMap);
            MapsManager.slabMap = ImmutableMap.copyOf(slabMap);
            MapsManager.blockMap = ImmutableMap.copyOf(blockMap);
            MapsManager.stonecuttingMap = ImmutableMap.copyOf(stonecuttingMap);
            MapsManager.waxingMap = ImmutableMap.copyOf(waxingMap);
            JustVerticalSlabsLoader.LOGGER.debug("justverticalslabs mod maps generated.");
        }

        private static final List<Ingredient> getBlockIngredients(NonNullList<Ingredient> ingredients) {
            return ingredients.stream().filter(ingredient -> Arrays.stream(ingredient.m_43908_()).allMatch(itemStack -> !itemStack.m_204117_(ItemTags.f_13139_) && itemStack.m_41720_() instanceof BlockItem)).toList();
        }

        private static final boolean sameIngredients(List<Ingredient> ingredients) {
            if (ingredients.size() > 0) {
                boolean same = true;
                Ingredient firstIngredient = ingredients.get(0);
                for (int i = 1; i < ingredients.size() && same; ++i) {
                    ItemStack[] blocks = ingredients.get(i).m_43908_();
                    for (int j = 0; j < blocks.length && same; ++j) {
                        same = firstIngredient.test(blocks[j]);
                    }
                }
                return same;
            }
            return false;
        }

        private static final boolean isPlain(String itemStackName) {
            return !itemStackName.contains("chiseled") && !itemStackName.contains("pillar") && !itemStackName.contains("smooth") && !itemStackName.contains("cut");
        }

        private static final boolean isTranslucent(String itemStackName) {
            return itemStackName.contains("transparent") || itemStackName.contains("spawner") || itemStackName.contains("glass") || itemStackName.contains("slime") || itemStackName.contains("honey") || itemStackName.contains("ice");
        }
    }
}

